#ifndef HW_EMULATOR_CAMERA3_USBSENSOR_H
#define HW_EMULATOR_CAMERA3_USBSENSOR_H

#include "Sensor.h"
#include "CameraIO.h"
#include "CameraUtil.h"
#include "OMXDecoder.h"
#include "CameraIO.h"
#include "CameraDevice.h"
#ifdef GE2D_ENABLE
#include "ge2d_stream.h"
#endif
#include "IonIf.h"
#include <atomic>
#define FRAME_DURATION (33333333L)

namespace android {

    class USBSensor:public Sensor {
        public:
            enum Decoder_Type{
                HW_NONE,
                HW_MJPEG,
                HW_H264,
            };
        public:
            USBSensor(int type);
            ~USBSensor();
        public:
            status_t streamOff(channel ch) override;
            status_t startUp(int idx) override;
            status_t shutDown(void) override;
            void captureYV12(StreamBuffer b, uint32_t gain) override;
            void captureYUYV(uint8_t *img, uint32_t gain, uint32_t stride) override;
            status_t getOutputFormat(void) override;
            status_t setOutputFormat(int width, int height, int pixelformat, channel ch) override;
            int halFormatToSensorFormat(uint32_t pixelfmt) override;
            status_t streamOn(channel ch) override;
            bool isStreaming() override;
            bool isNeedRestart(uint32_t width, uint32_t height, uint32_t pixelformat, channel ch) override;
            int getStreamConfigurations(uint32_t picSizes[], const int32_t kAvailableFormats[], int size) override;
            int getStreamConfigurationDurations(uint32_t picSizes[], int64_t duration[], int size, bool flag) override;
            int64_t getMinFrameDuration() override;
            int getPictureSizes(int32_t picSizes[], int size, bool preview) override;
            status_t force_reset_sensor() override;
            int captureNewImage() override;
            //-------dummy function-------
            int getZoom(int *zoomMin, int *zoomMax, int *zoomStep) override;
            int setZoom(int zoomValue) override;
            status_t setEffect(uint8_t effect) override;
            int getExposure(int *maxExp, int *minExp, int *def, camera_metadata_rational *step) override;
            status_t setExposure(int expCmp) override;
            int getAntiBanding(uint8_t *antiBanding, uint8_t maxCont) override;
            status_t setAntiBanding(uint8_t antiBanding) override;
            status_t setFocusArea(int32_t x0, int32_t y0, int32_t x1, int32_t y1) override;
            int getAutoFocus(uint8_t *afMode, uint8_t maxCount) override;
            status_t setAutoFocus(uint8_t afMode) override;
            int getAWB(uint8_t *awbMode, uint8_t maxCount) override;
            status_t setAWB(uint8_t awbMode) override;
            void setSensorListener(SensorListener *listener) override;
            uint32_t getStreamUsage(camera3_stream_t& stream) override;
        private:
            CameraVirtualDevice* mCameraVirtualDevice;
            int mUSBDevicefd;
            FILE *fp;
            enum Decode_Method{
                DECODE_SOFTWARE,
                DECODE_OMX,
                DECODE_MAX,
            };
            int mUseHwType;
            enum Decode_Method mDecodeMethod;
            OMXDecoder* mDecoder;
            CameraUtil* mCameraUtil;
            Vector<uint32_t> mSupportFormat;
            Vector<uint32_t> mTryPixelFormat;
            uint32_t mCurrentFormat;
            bool mIsDecoderInit;
            //store the v4l2 info
            CVideoInfo *mVinfo;
            uint8_t* mImage_buffer;
            uint8_t* mDecodedBuffer;
#ifdef GE2D_ENABLE
            IONInterface* mION;
            ge2dTransform* mGE2D;
#endif
            bool mAsyncEnable;
            bool mHwDecoderSensor;
            StreamBuffer mSensorOutBuf;
            std::atomic<bool> mDecFillBufThreadNeedStop;
            Mutex mDecFillThreadResetLock;
            bool mDecFillThreadNeedReset;
            Mutex mDecFillThreadWaitLock;
            pthread_t mDecFillBufThreadTid;
        protected:
            virtual status_t readyToRun();
        private:
            USBSensor();
            void dump(int& frame_index,uint8_t* buf, int length, std::string name);
            void initDecoder(int in_width, int in_height,
                                        int out_width, int out_height, int out_bufferCount);
            int OMXToNV21(uint8_t* src, Vector<StreamBuffer>& b, bool isJpegRequest);
            int SensorInit(int idx);
            void InitVideoInfo(int idx);
            int camera_open(int idx);
            void camera_close(void);
            const char* getformt(int id);
            void setIOBufferNum();
            void captureNV21UsbSensor(StreamBuffer b, uint32_t gain, bool needSensorOutBuf);
            void captureNV21UsbSensor(Vector<StreamBuffer>& b, uint32_t gain, bool isJpegRequest);
            static void *DecFillBufThread(void *sensor);
            int DecFillBufThreadStart();
            void DecFillBufThreadStop();
            int ResetSensorAndDecoder();

    };
}
#endif


