/*
 * Copyright (C) 2018 Amlogic Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __AML_RESAMPLE_H__
#define __AML_RESAMPLE_H__

#include <audio-dec.h>
#include <adec-pts-mgt.h>
#include <audiodsp_update_format.h>
#define Q14(ratio)          ((ratio)*(1<<14))
#define Q14_INT_GET(value)  ((value)>>14)
#define Q14_FRA_GET(value)  ((value)&0x3fff)

#define RESAMPLE_DELTA_NUMSAMPS 1
#define DEFAULT_NUMSAMPS_PERCH   128
#define MAX_NUMSAMPS_PERCH      (DEFAULT_NUMSAMPS_PERCH + RESAMPLE_DELTA_NUMSAMPS)
#define DEFAULT_NUMCH            2

#define RESAMPLE_TYPE_NONE      0
#define RESAMPLE_TYPE_DOWN      1
#define RESAMPLE_TYPE_UP        2

#define RESAMPLE_DOWN_FORCE_PCR_SLOW 3

typedef struct af_resample_ctl_s {
    int   SampNumIn;
    int   SampNumOut;
    int   InterpolateCoefArray[MAX_NUMSAMPS_PERCH];
    short InterpolateIndexArray[MAX_NUMSAMPS_PERCH];
    short ReservedBuf[MAX_NUMSAMPS_PERCH*DEFAULT_NUMCH];
    short ReservedSampsValid;
    short OutSampReserveBuf[MAX_NUMSAMPS_PERCH*DEFAULT_NUMCH];
    short OutSampReserveLen;
    short InitFlag;
    short LastResamType;
    int resample_type;
    short enable_resample;
} af_resample_ctl_t;

void af_resample_linear_init(struct aml_audio_dec* audec);

void af_resample_linear_stop(struct aml_audio_dec* audec);

int af_get_resample_enable_flag();

af_resample_ctl_t* af_resampler_ctx_get();

void af_resample_set_SampsNumRatio(af_resample_ctl_t *paf_resample_ctl);

void af_get_pcm_in_resampler(af_resample_ctl_t *paf_resample_ctl, short*buf, int *len);


void  af_resample_process_linear_inner(af_resample_ctl_t *paf_resample_ctl,
                                       short *data_in, int *NumSamp_in,
                                       short* data_out, int* NumSamp_out, int NumCh);
void  af_resample_stop_process(af_resample_ctl_t *paf_resample_ctl);


int af_get_delta_inputsampnum(af_resample_ctl_t *paf_resample_ctl, int Nch);

void  af_get_unpro_inputsampnum(af_resample_ctl_t *paf_resample_ctl, short *buf, int *num);

void af_resample_api_normal(char *buffer, unsigned int *size, int Chnum, aml_audio_dec_t *audec);

void af_resample_api(char* buffer, unsigned int * size, int Chnum, aml_audio_dec_t* audec, int enable, int delta);

int af_set_resample_type(int val);

void  af_pcrmaster_resample_api(char *buffer, unsigned int *size, int Chnum, aml_audio_dec_t *audec/*, int enable, int delta*/);

#endif

















