LOCAL_PATH:= $(call my-dir)
include $(TOP)/hardware/amlogic/media/media_base_config.mk
AMAVUTILS_INCLUDE=$(AMAVUTILS_PATH)/include/


include $(CLEAR_VARS)

LOCAL_CFLAGS := \
        -fPIC -D_POSIX_SOURCE
#ifdef DOLBY_UDC
    LOCAL_CFLAGS+=-DDOLBY_USE_ARMDEC
#endif

ifdef DOLBY_DS1_UDC
  LOCAL_CFLAGS += -DDOLBY_DS1_UDC
endif

LOCAL_HEADER_LIBRARIES := libmedia_headers libaudio_system_headers


LOCAL_C_INCLUDES:= \
    $(LOCAL_PATH)/include \
    $(AMAVUTILS_INCLUDE) \
    hardware/amlogic/audio/audio_hal \
    hardware/amlogic//audio/utils/include/ \
    hardware/amlogic/audio/dtv_audio_utils/audio_read_api \
    hardware/amlogic/audio/dtv_audio_utils/sync/

# PLATFORM_SDK_VERSION:
# 4.4 = 19
# 4.3 = 18
# 4.2 = 17
LOCAL_CFLAGS += -DANDROID_PLATFORM_SDK_VERSION=$(PLATFORM_SDK_VERSION)

ifneq (0, $(shell expr $(PLATFORM_VERSION) \>= 4.3))
    LOCAL_CFLAGS += -DANDROID_VERSION_JBMR2_UP=1
    ifneq ($(TARGET_BOARD_PLATFORM),meson6)
        LOCAL_CFLAGS += -DUSE_ARM_AUDIO_DEC
    endif
endif

ifneq (0, $(shell expr $(PLATFORM_VERSION) \> 4.1.0))
    LOCAL_CFLAGS += -D_VERSION_JB
else
    ifneq (0, $(shell expr $(PLATFORM_VERSION) \> 4.0.0))
        LOCAL_CFLAGS += -D_VERSION_ICS
    endif
endif

LOCAL_SRC_FILES := \
           adec-external-ctrl.c adec-internal-mgt.c adec-ffmpeg-mgt.c adec-message.c adec-pts-mgt.c adec_write.c adec_read.c\
           audio_out/dtv_patch_out.c audio_out/aml_resample.c audiodsp_update_format.c
LOCAL_MODULE := libamadec
LOCAL_LICENSE_KINDS := SPDX-license-identifier-Apache-2.0 SPDX-license-identifier-GPL
LOCAL_LICENSE_CONDITIONS := notice restricted


include $(BUILD_STATIC_LIBRARY)


include $(CLEAR_VARS)

LOCAL_CFLAGS := \
        -fPIC -D_POSIX_SOURCE
#ifdef DOLBY_UDC
    LOCAL_CFLAGS+=-DDOLBY_USE_ARMDEC
#endif

LOCAL_HEADER_LIBRARIES := libmedia_headers libaudio_system_headers

LOCAL_C_INCLUDES:= \
    $(LOCAL_PATH)/include \
    $(AMAVUTILS_INCLUDE) \
    hardware/amlogic/audio/audio_hal \
    hardware/amlogic/audio/utils/include \
    hardware/amlogic/audio/dtv_audio_utils/audio_read_api \
    hardware/amlogic/audio/dtv_audio_utils/sync/


LOCAL_CFLAGS += -DANDROID_PLATFORM_SDK_VERSION=$(PLATFORM_SDK_VERSION)
LOCAL_CFLAGS += -DUSE_ARM_AUDIO_DEC
ifneq (0, $(shell expr $(PLATFORM_VERSION) \>= 4.3))
    LOCAL_CFLAGS += -DANDROID_VERSION_JBMR2_UP=1
endif

ifneq (0, $(shell expr $(PLATFORM_VERSION) \> 4.1.0))
    LOCAL_CFLAGS += -D_VERSION_JB
else
    ifneq (0, $(shell expr $(PLATFORM_VERSION) \> 4.0.0))
        LOCAL_CFLAGS += -D_VERSION_ICS
    endif
endif

LOCAL_SRC_FILES := \
           adec-external-ctrl.c adec-internal-mgt.c adec-ffmpeg-mgt.c adec-message.c adec-pts-mgt.c adec_write.c adec_read.c\
           audio_out/dtv_patch_out.c  \
           adec_omx_bridge.c

LOCAL_MODULE := libamadec
LOCAL_LICENSE_KINDS := SPDX-license-identifier-Apache-2.0 SPDX-license-identifier-GPL
LOCAL_LICENSE_CONDITIONS := notice restricted

ifeq ($(shell test $(PLATFORM_SDK_VERSION) -ge 26 && echo OK),OK)
LOCAL_PROPRIETARY_MODULE := true
endif

##################################################
#$(shell cp $(LOCAL_PATH)/acodec_lib/*.so $(TARGET_OUT)/lib)
###################################################
LOCAL_SHARED_LIBRARIES += libutils libz libbinder libdl libcutils libc libamavutils liblog libamaudioutils libdvbaudioutils

LOCAL_PRELINK_MODULE := false
LOCAL_MODULE_TAGS := optional
include $(BUILD_SHARED_LIBRARY)

ifeq (0, $(shell expr $(PLATFORM_VERSION) \>= 6.0))
include $(CLEAR_VARS)

ifeq ($(TARGET_BOARD_PLATFORM),meson6)
    audio_firmware_dir := firmware-m6
else ifeq ($(TARGET_BOARD_PLATFORM),meson8)
    audio_firmware_dir := firmware-m8
else
    audio_firmware_dir := firmware
endif

# generate md5 checksum files
$(shell cd $(LOCAL_PATH)/$(audio_firmware_dir) && { \
for f in *.bin; do \
  md5sum "$$f" > "$$f".checksum; \
done;})

# gather list of relative filenames
audio_firmware_files := $(wildcard $(LOCAL_PATH)/$(audio_firmware_dir)/*.bin)
audio_firmware_files += $(wildcard $(LOCAL_PATH)/$(audio_firmware_dir)/*.checksum)
audio_firmware_files := $(patsubst $(LOCAL_PATH)/%,%,$(audio_firmware_files))

# define function to create a module for each file
# $(1): filename
define _add-audio-firmware-module
    include $$(CLEAR_VARS)
    LOCAL_MODULE := audio-firmware_$(notdir $(1))
    LOCAL_LICENSE_KINDS := SPDX-license-identifier-Apache-2.0 SPDX-license-identifier-GPL
    LOCAL_LICENSE_CONDITIONS := notice restricted
    LOCAL_MODULE_STEM := $(notdir $(1))
    _audio_firmware_modules += $$(LOCAL_MODULE)
    LOCAL_SRC_FILES := $1
    LOCAL_MODULE_TAGS := optional
    LOCAL_MODULE_CLASS := ETC
    LOCAL_MODULE_PATH := $(TARGET_OUT_VENDOR)/etc/firmware
    include $$(BUILD_PREBUILT)
endef

# create modules, one for each file
_audio_firmware_modules :=
_audio_firmware :=
$(foreach _firmware, $(audio_firmware_files), \
  $(eval $(call _add-audio-firmware-module,$(_firmware))))

#LOCAL_PATH := $(call my-dir)

include $(CLEAR_VARS)

LOCAL_MODULE := audio_firmware
LOCAL_LICENSE_KINDS := SPDX-license-identifier-Apache-2.0 SPDX-license-identifier-GPL
LOCAL_LICENSE_CONDITIONS := notice restricted
LOCAL_MODULE_CLASS := ETC
LOCAL_MODULE_TAGS := optional

LOCAL_REQUIRED_MODULES := $(_audio_firmware_modules)

include $(BUILD_PHONY_PACKAGE)

_audio_firmware_modules :=
_audio_firmware :=
endif
