/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// All static variables go here, to control initialization and
// destruction order in the library.

#ifndef ANDROID_HARDWARE_HIDL_STATIC_H
#define ANDROID_HARDWARE_HIDL_STATIC_H

#include <functional>

#include <android/hidl/base/1.0/IBase.h>
#include <hidl/ConcurrentMap.h>
#include <hwbinder/IBinder.h>
#include <hwbinder/IInterface.h>
#include <utils/StrongPointer.h>

namespace android {
namespace hardware {
namespace details {

// TODO(b/69122224): remove this
// For HidlBinderSupport and autogenerated code
extern DoNotDestruct<ConcurrentMap<const ::android::hidl::base::V1_0::IBase*,
                                   wp<::android::hardware::BHwBinder>>>
        gBnMap;

using BnConstructorMap = ConcurrentMap<std::string, std::function<sp<IBinder>(void*)>>;
// For HidlBinderSupport and autogenerated code
// value function receives reinterpret_cast<void *>(static_cast<IFoo *>(foo)),
// returns sp<IBinder>
BnConstructorMap& getBnConstructorMap();

using BsConstructorMap = ConcurrentMap<std::string,
        std::function<sp<::android::hidl::base::V1_0::IBase>(void*)>>;
// For HidlPassthroughSupport and autogenerated code
// value function receives reinterpret_cast<void *>(static_cast<IFoo *>(foo)),
// returns sp<IBase>
BsConstructorMap& getBsConstructorMap();
}  // namespace details
}  // namespace hardware
}  // namespace android

#endif
