/**********************************************************************************
 *
 * Copyright (C) 2017 The Android Open Source Project
 * Copyright (C) 2020 SeekWave Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************/
#ifndef __WIFI_COMMAND_H__
#define __WIFI_COMMAND_H__

#include "main.h"
#include "nl80211_copy.h"

#define SKW_VID_GET_VALID_CHANNELS                0x1009
#define SKW_VID_SET_COUNTRY                       0x100E
#define SKW_VID_GET_VERSION                       0x1403
#define SKW_VID_GET_RING_BUFFERS_STATUS           0x1404
#define SKW_VID_GET_LOGGER_FEATURE                0x1406

#define SKW_VID_GET_APF_CAPABILITIES              0x1800
#define SKW_VID_GET_USABLE_CHANS                  0x2000
#define SKW_VID_CREATE_IFACE                      0x2001
#define SKW_VID_DELETE_IFACE                      0x2001

#define SKW_ATTR_VALID_CHANNELS_BAND              20
#define SKW_ATTR_VALID_CHANNELS_COUNT             36
#define SKW_ATTR_VALID_CHANNELS_LIST              37

#define SKW_ATTR_SET_COUNTRY                      5

#define SKW_ATTR_VERSION_DRIVER                   1
#define SKW_ATTR_VERSION_FIRMWARE                 2

#define SKW_ATTR_RING_BUFFERS_STATUS              13
#define SKW_ATTR_RING_BUFFERS_COUNT               14

#define SKW_ATTR_APF_VERSION                      0
#define SKW_ATTR_APF_MAX_LEN                      1

class WifiCommand {
private:
	struct nl_msg *msg;
	struct nl_sock *sock;
	int id;

public:
	WifiCommand(struct nl_sock *sk, int family_id, int flags, int nl80211_cmd);

	wifi_error send();
	virtual ~WifiCommand();
	virtual wifi_error parser(struct nlattr *attr[]) = 0;
	virtual void setVendorCommand(wifi_interface_handle handle, int vid)
	{
		interface_info *iface = (interface_info *)handle;

		if (iface->wdev_idx)
			put_u32(NL80211_ATTR_WDEV, iface->wdev_idx);
		else
			put_u32(NL80211_ATTR_IFINDEX, iface->iface_idx);

		put_u32(NL80211_ATTR_VENDOR_ID, OUI_GOOGLE);
		put_u32(NL80211_ATTR_VENDOR_SUBCMD, vid);
	}

	struct nl_msg *nlmsg()
	{
		return msg;
	}

	int put_s8(int attribute, int8_t value)
	{
		return nla_put(nlmsg(), attribute, sizeof(int8_t), &value);
	}

	int put_u8(int attribute, uint8_t value)
	{
		return nla_put(nlmsg(), attribute, sizeof(uint8_t), &value);
	}

	int put_s16(int attribute, int16_t value)
	{
		return nla_put(nlmsg(), attribute, sizeof(int16_t), &value);
	}

	int put_u16(int attribute, uint16_t value)
	{
		return nla_put(nlmsg(), attribute, sizeof(uint16_t), &value);
	}

	int put_s32(int attribute, int32_t value)
	{
		return nla_put(nlmsg(), attribute, sizeof(int32_t), &value);
	}

	int put_u32(int attribute, uint32_t value)
	{
		return nla_put(nlmsg(), attribute, sizeof(uint32_t), &value);
	}

	int put_s64(int attribute, int64_t value)
	{
		return nla_put(nlmsg(), attribute, sizeof(int64_t), &value);
	}

	int put_u64(int attribute, uint64_t value)
	{
		return nla_put(nlmsg(), attribute, sizeof(uint64_t), &value);
	}

	int put_data(int attribute, int size, void *data)
	{
		return nla_put(nlmsg(), attribute, size, data);
	}

	int put_string(int attribute, const char *value)
	{
		return nla_put(nlmsg(), attribute, strlen(value) + 1, value);
	}

	int put_addr(int attribute, mac_addr value)
	{
		return nla_put(nlmsg(), attribute, sizeof(mac_addr), value);
	}

	struct nlattr *attr_start()
	{
		return nla_nest_start(nlmsg(), NL80211_ATTR_VENDOR_DATA);
	}

	void attr_end(struct nlattr *attribute)
	{
		nla_nest_end(nlmsg(), attribute);
	}
};

#endif
