LOCAL_PATH := $(call my-dir)

ifeq ($(BOARD_HAVE_BLUETOOTH_SPRD),true)

include $(CLEAR_VARS)

SPRD_WCNBT_CHISET := marlin3
BDROID_DIR := $(TOP_DIR)packages/modules/Bluetooth/system

LOCAL_SRC_FILES := \
        src/bt_vendor_sprd.c \
        src/hardware.c \
        src/userial_vendor.c \
        src/upio.c \
        src/conf.c \
        src/sitm.c \
        conf/sprd/$(SPRD_WCNBT_CHISET)/src/$(SPRD_WCNBT_CHISET).c \
        src/bt_vendor_sprd_hci.c \
        src/FallthroughBTA.cpp

LOCAL_C_INCLUDES += \
        $(LOCAL_PATH)/include \
        $(BDROID_DIR)/ \
        $(BDROID_DIR)/hci/include \
        $(BDROID_DIR)/include \
        $(BDROID_DIR)/stack/btm \
        $(BDROID_DIR)/stack/include \
        $(BDROID_DIR)/gki/ulinux \
        $(LOCAL_PATH)/conf/sprd/$(SPRD_WCNBT_CHISET)/include \
        $(TOP_DIR)vendor/amlogic/common/wifi_bt/bluetooth/common/include

LOCAL_ALGO_SRC_FILES:= \
        src/bt_vendor_sprd_ssp.c \
        src/algorithms/p_256_ecc_pp.c \
        src/algorithms/p_256_curvepara.c \
        src/algorithms/p_256_multiprecision.c \
        src/algorithms/lmp_ecc.c \
        src/algorithms/algo_api.c \
        src/algorithms/algo_utils.c

LOCAL_ALGO_C_INCLUDES := $(LOCAL_PATH)/src/algorithms

LOCAL_SRC_FILES += $(LOCAL_ALGO_SRC_FILES)
LOCAL_C_INCLUDES += $(LOCAL_ALGO_C_INCLUDES)

LOCAL_SHARED_LIBRARIES := \
        libcutils \
        libutils \
        liblog

LOCAL_HEADER_LIBRARIES:= libbluetooth_headers


## Special configuration ##
ifeq ($(BOARD_SPRD_WCNBT_MARLIN), true)
    ifneq ($(strip $(WCN_EXTENSION)),true)
        LIBBT_CFLAGS += -DSPRD_WCNBT_MARLIN_15A
    else
        LIBBT_CFLAGS += -DGET_MARLIN_CHIPID
    endif
endif

ifneq ($(BOARD_BLUETOOTH_BDROID_BUILDCFG_INCLUDE_DIR),)
  bdroid_C_INCLUDES := $(BOARD_BLUETOOTH_BDROID_BUILDCFG_INCLUDE_DIR)
  bdroid_CFLAGS += -DHAS_BDROID_BUILDCFG
else
  bdroid_C_INCLUDES :=
  bdroid_CFLAGS += -DHAS_NO_BDROID_BUILDCFG
endif

LOCAL_C_INCLUDES += $(bdroid_C_INCLUDES)
LOCAL_CFLAGS := $(LIBBT_CFLAGS) $(bdroid_CFLAGS)
LOCAL_CFLAGS += -Wno-unused-variable
LOCAL_CFLAGS += -Wno-unused-value
LOCAL_CFLAGS += -Wno-unused-function
ifeq ($(BOARD_HAVE_BLUETOOTH_MULTIBT),true)
    LOCAL_MODULE := libbt-vendor_uwe
else
    LOCAL_MODULE := libbt-vendor
endif
LOCAL_MODULE_TAGS := optional
LOCAL_MODULE_CLASS := SHARED_LIBRARIES
LOCAL_MODULE_OWNER := sprd
LOCAL_PROPRIETARY_MODULE := true

LOCAL_LICENSE_KINDS := SPDX-license-identifier-Apache-2.0
LOCAL_LICENSE_CONDITIONS := notice
LOCAL_NOTICE_FILE := $(LOCAL_PATH)/../../../../LICENSE

include $(LOCAL_PATH)/vnd_buildcfg.mk

include $(BUILD_SHARED_LIBRARY)

endif
