/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2014. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifndef _OS_DEP_H
#define _OS_DEP_H

#include <errno.h>
#include <unistd.h>
#include <stdbool.h>
#include <string.h>

#ifndef FALSE
#define FALSE    0
#endif
#ifndef TRUE
#define TRUE     1
#endif
#ifndef BOOL
#define BOOL     bool
#endif

typedef unsigned char BYTE;
typedef unsigned char UCHAR;
typedef unsigned char UINT8;
typedef unsigned short UINT16;
typedef unsigned int UINT32;
typedef unsigned long long UINT64;
typedef unsigned char* PBYTE;
typedef unsigned char* PUCHAR;
typedef char INT8;
typedef short INT16;
typedef int INT32;
typedef long long INT64;
typedef void VOID;
typedef void* PVOID;

#if defined(MTK_BT_SYS_LOG)
#include <syslog.h>
extern int vendor_log_save_to_syslog;
/*control by /data/log_all file exist or not*/
#define printf(format, args...)                    \
    do {                                           \
        if (1 == vendor_log_save_to_syslog)        \
        {                                          \
            syslog(LOG_WARNING, format, ##args);   \
        }                                          \
        else                                       \
        {                                          \
            syslog(LOG_WARNING, format, ##args);   \
            printf(format, ##args);                \
        }                                          \
    } while (0)
#endif

/* LOG_TAG must be defined before log.h */
#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG               "[BT]"

#if defined(MTK_LINUX)
#if defined(MTK_COMMON) && (MTK_COMMON == TRUE)
#define LOGWRAPPER(tag, fmt, args...) printf("%s(pid:%d): " fmt "\n", tag, getpid(), ## args)
#else
#define LOGWRAPPER(tag, fmt, args...) fprintf(stderr, "%s: " fmt "\n", tag, ## args)
#endif

#define BT_DRIVER_DEBUG       1

#define LOG_ERR(...)       LOGWRAPPER(LOG_TAG,__VA_ARGS__)
#define LOG_WAN(...)       LOGWRAPPER(LOG_TAG,__VA_ARGS__)
#if BT_DRIVER_DEBUG
#define LOG_DBG(...)       LOGWRAPPER(LOG_TAG,__VA_ARGS__)
#define LOG_TRC(f)         ((void)0)
#define LOG_PER(...)       LOGWRAPPER(LOG_TAG,__VA_ARGS__)
#else
#define LOG_DBG(...)          ((void)0)
#define LOG_TRC(f)            ((void)0)
#define LOG_PER(f, ...)       ((void)0)
#endif

#else
#include <cutils/log.h>

#define BT_DRIVER_DEBUG       1
#define LOG_ERR(f, ...)       ALOGE("%s(PID:%d): " f, __FUNCTION__, getpid(), ##__VA_ARGS__)
#define LOG_WAN(f, ...)       ALOGW("%s(PID:%d): " f, __FUNCTION__, getpid(), ##__VA_ARGS__)
#if BT_DRIVER_DEBUG
#define LOG_DBG(f, ...)       ALOGD("%s: " f,  __FUNCTION__, ##__VA_ARGS__)
#define LOG_TRC(f)            ALOGW("%s #%d", __FUNCTION__, __LINE__)
#define LOG_PER(f, ...)       ALOGD("" f, ##__VA_ARGS__)
#else
#define LOG_DBG(...)          ((void)0)
#define LOG_TRC(f)            ((void)0)
#define LOG_PER(f, ...)       ((void)0)
#endif
#endif

#define LOG_ERRORNO(error_code, fmt, ...)                               \
    do {                                                                \
        char error_string[64];                                          \
        memset(error_string, 0, sizeof(error_string));                  \
        strerror_r(error_code, error_string, sizeof(error_string));     \
        LOG_ERR(fmt" %s(%d)\n", ##__VA_ARGS__, error_string, error_code); \
    } while (0)

#define LOG_WARNNO(error_code, fmt, ...)                                \
    do {                                                                \
        char error_string[64];                                          \
        memset(error_string, 0, sizeof(error_string));                  \
        strerror_r(error_code, error_string, sizeof(error_string));     \
        LOG_WAN(fmt" %s(%d)\n", ##__VA_ARGS__, error_string, error_code); \
    } while (0)

#endif
