/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2014. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#if defined(MTK_LINUX)
//#include "osi/include/properties.h"
#else
#include <cutils/properties.h>
#endif
#include "bt_mtk.h"

/**************************************************************************
 *                  G L O B A L   V A R I A B L E S                       *
***************************************************************************/
static int  bt_fd = -1;

/**************************************************************************
 *              F U N C T I O N   D E C L A R A T I O N S                 *
***************************************************************************/

/**************************************************************************
 *                          F U N C T I O N S                             *
***************************************************************************/

EXPORT_SYMBOL int bt_init(void)
{
    int retry = 50;
    LOG_TRC();

    if (bt_fd >= 0) {
        LOG_WAN("Previous serial port is not closed\n");
        close_uart();
    }

    while(1) {
        bt_fd = open("/dev/stpbt", O_RDWR | O_NOCTTY | O_NONBLOCK | O_CLOEXEC);
        if (bt_fd < 0) {
            LOG_WAN("Can't open serial port, Retry\n");
            usleep(200000);/*200ms*/
            if (retry <= 0)
                break;
            retry--;
        }
        else
            break;
    }

    if (bt_fd < 0) {
        LOG_ERR("Can't open serial port stpbt\n");
        return -1;
    }

    return bt_fd;
}

EXPORT_SYMBOL int bt_restore(int fd)
{
    if (bt_fd >= 0) close(bt_fd);
    bt_fd = -1;
    return 0;
}

static int write_com_port(int fd, unsigned char *buf, unsigned int len)
{
    int nWritten = 0;
    unsigned int bytesToWrite = len;

    if (fd < 0) {
        LOG_ERR("No available com port\n");
        return -EIO;
    }

    while (bytesToWrite > 0) {
        nWritten = write(fd, buf, bytesToWrite);
        if (nWritten < 0) {
            if (errno == EINTR || errno == EAGAIN)
                break;
            else
                return -errno; /* errno used for whole chip reset */
        }
        bytesToWrite -= nWritten;
        buf += nWritten;
    }

    return (len - bytesToWrite);
}

static int read_com_port(int fd, unsigned char *buf, unsigned int len)
{
    int nRead = 0;
    unsigned int bytesToRead = len;

    if (fd < 0) {
        LOG_ERR("No available com port\n");
        return -EIO;
    }

    nRead = read(fd, buf, bytesToRead);
    if (nRead < 0) {
        if(errno == EINTR || errno == EAGAIN)
            return 0;
        else
            return -errno; /* errno used for whole chip reset */
    }

    return nRead;
}

EXPORT_SYMBOL int bt_send_data(int fd, unsigned char *buf, unsigned int len)
{
    int bytesWritten = 0;
    unsigned int bytesToWrite = len;

    /* Try to send len bytes data in buffer */
    while (bytesToWrite > 0) {
        bytesWritten = write_com_port(fd, buf, bytesToWrite);
        if (bytesWritten < 0) {
            return -1;
        }
        bytesToWrite -= bytesWritten;
        buf += bytesWritten;
    }

    return 0;
}

EXPORT_SYMBOL int bt_receive_data(int fd, unsigned char *buf, unsigned int len)
{
    int bytesRead = 0;
    unsigned int bytesToRead = len;

    int ret = 0;
    struct timeval tv;
    fd_set readfd;

    tv.tv_sec = 5; /* SECOND */
    tv.tv_usec = 0; /* USECOND */
    FD_ZERO(&readfd);

    /* Try to receive len bytes */
    while (bytesToRead > 0) {

        FD_SET(fd, &readfd);
        ret = select(fd + 1, &readfd, NULL, NULL, &tv);

        if (ret > 0) {
            bytesRead = read_com_port(fd, buf, bytesToRead);
            if (bytesRead < 0) {
                return -1;
            }
            else {
                bytesToRead -= bytesRead;
                buf += bytesRead;
            }
        }
        else if (ret == 0) {
            LOG_DBG("Read com port timeout 5000ms!\n");
            return -1;
        }
        else if ((ret == -1) && (errno == EINTR)) {
            LOG_ERR("select error EINTR\n");
        }
        else {
            LOG_ERRORNO(errno, "select error ");
            return -1;
        }
    }
    return 0;
}

